jQuery(function($){

	var tituloGrafico = "";
	var tipoGrafico = "area";
	var unidadMedida = "";
	var nombreContaminante = "";
	var arrLimites = null;
	
	$("#divResultado").hide();
	
	$("#divCriteriosBusqueda").rup_accordion({
		collapsible: true
	});
	
	$("#btnBuscar").button({
		icons:{primary: "ui-icon-search"}
	}).click(function(){		
		if (fncValidarBusqueda(true)){
			
			blockUI_Cargando();
			
			fncObtenerDatosContaminanteEstacion();			
		}
		
	});
	
	$("#btnLimpiar").button({
		icons:{
			primary: "ui-icon-trash"
		}
	}).click(function(){
		$("#FORMULARIO_BUSQUEDA").rup_form("clearForm");
		$("#txtFecha").val(fechaActual);		
	});
	
	//boton que muestra el popup de exportar
	$("#btnMostrarExportar").button({
		icons:{
			primary: "ui-icon-arrowstop-1-s"
		}
	}).click(function(){
		//antes de mostrar el popup de exportar, valido los datos del formulario
		if (fncValidarBusqueda(false)){
			
			//si el rango de fechas seleccionado es mayor de 3 meses
			if (monthsDiff($("#txtFecha").rup_date("getRupValue"), $("#txtFechaHasta").rup_date("getRupValue")) > 3){
				//no permito exportar datos horarios
				$("#rdoHorarios").attr("disabled","disabled");
				$("#lblAviso3Meses").removeClass("ocultar");
				$("#rdoDiarios").attr("checked","checked");
			}else{
				$("#rdoHorarios").removeAttr("disabled");
				$("#lblAviso3Meses").addClass("ocultar");
				$("#rdoHorarios").attr("checked","checked");
			}
			
			//abro el popup de exportar
			$( "#detalleExportar" ).rup_dialog( "open" );
			
		}
				
	});
	
	//popup de edición 
	$("#detalleExportar").rup_dialog({
		autoOpen: false,
		width: 300,
		modal: true,
		resizable: false,
		position: "center",
		type: $.rup.dialog.DIV
	});
	
	//configuro el formulario de exportar
	$("#FORMULARIO_EXPORTAR").attr('action', $.rup.CTX_PATH + 'informe/datosHistorico?R01HNoPortal=true');
	$("#FORMULARIO_EXPORTAR").attr('method', 'POST');
	$("#FORMULARIO_EXPORTAR").attr("target","_blank");
	
	//boton Exportar
	$("#btnExportar").button({
		icons:{
			primary: "ui-icon-arrowstop-1-s"
		}
	}).click(function(){
		
		/*if ($("input[name=tipoDatos]:checked").val() == TIPO_DATOS_HORARIOS){
			if (monthsDiff($("#txtFecha").rup_date("getRupValue"), $("#txtFechaHasta").rup_date("getRupValue")) > 3){
				alert("No se permite exportar datos horarios de más de 3 meses.");
				return;
			}
		}*/
		
		//vuelco los datos del filtro al formulario de exportar		
		$("#idEstacion").val($("#cmbEstacion").rup_combo("getRupValue"));
		$("#nombreEstacion").val($("#cmbEstacion").rup_combo("label")); //vuelco tambien el nombre de la estacion para mostrarlo en el informe
		$("#fechaExportarDesde").val($("#txtFecha").val());
		$("#fechaExportarHasta").val($("#txtFechaHasta").val());
		
		$("#nombreContaminante").val($("#cmbContaminante").rup_combo("label"));
		
		$("#FORMULARIO_EXPORTAR").submit();
		
		$( "#detalleExportar" ).rup_dialog( "close" );
	});
	
	//Configuramos los campos como date
	/*$.rup_date({
		from: "txtFecha",
		to: "txtFechaHasta"
	});*/
	
	//defino los campos del rango de fecha manualmente porque el de UDA no funciona correctamente
	$("#txtFecha").rup_date({
		 onClose: function( selectedDate ) {
	        $( "#txtFechaHasta" ).datepicker( "option", "minDate", selectedDate );
	      }
	});
	
	$("#txtFechaHasta").rup_date({
		onClose: function( selectedDate ) {
	        $( "#txtFecha" ).datepicker( "option", "maxDate", selectedDate );
	      }
	});
	
	
	//cargo los avisos generales con el metodo definido en el _layout.js
	cargarAvisosGenerales();
	
	var anchoComboEstacion=$('#divCriteriosBusqueda').width()*0.25;
	
	$("#cmbEstacion").rup_combo({
		source : $.rup.CTX_PATH+"combo/estaciones",
		sourceParam : {
			label:"descripcion", 
			value:"valor"
		},
		width: anchoComboEstacion,
		blank : ""
	});
	
	$("#cmbContaminante").rup_combo({
		parent : [ "cmbEstacion" ],
		source : $.rup.CTX_PATH+"combo/contaminantes/",
		sourceParam : {
			label:"descripcion", 
			value:"valor"
		},
		width: anchoComboEstacion,
		blank : ""
	});
	
	function fncValidarBusqueda(bIncluirContaminante){
		
		var strMensaje = "";
		var strSeparador = "";
		
		if ($("#cmbEstacion").rup_combo("getRupValue") == ""){			
			strMensaje = " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_estacion;
			strSeparador = "<br /><br />";			
		}
		
		if (bIncluirContaminante){
			//si no hay ningún check de contaminante seleccionado
			if ($("#cmbContaminante").rup_combo("getRupValue") == ""){
				strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_contaminante;
				strSeparador = "<br /><br />";
			}
		}
		
		if ($("#txtFecha").rup_date("getDate") == "" && $("#txtFechaHasta").rup_date("getDate") == ""){
			strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_rango_fechas;
		}else{
		
			if ($("#txtFecha").rup_date("getDate") == ""){
				strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_rango_fechas;
			}else{
				//valido si es una fecha correcta
				var valida = $.rup_validate.checkDate($.rup.i18n.base.rup_validate.format.date,$("#txtFecha").rup_date("getDate"));
				if (!valida){
					//si no es correcta, muestro mensaje de error
					strMensaje += strSeparador + " - " + $.rup.i18n.base.rup_validate.messages.date;
				}
			}
			
			if ($("#txtFechaHasta").rup_date("getDate") == ""){
				strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_rango_fechas;
			}else{
				//valido si es una fecha correcta
				var valida = $.rup_validate.checkDate($.rup.i18n.base.rup_validate.format.date,$("#txtFechaHasta").rup_date("getDate"));
				if (!valida){
					//si no es correcta, muestro mensaje de error
					strMensaje += strSeparador + " - " + $.rup.i18n.base.rup_validate.messages.date;
				}
			}
		
		}
		
		if (strMensaje != ""){
			$("#feedbackMensajes").rup_feedback("set", strMensaje, "alert");
			return false;
		}else{
			return true;
		}
		
	}
	
	$("#cmbCambiarGrafico").change(function(){
		tipoGrafico = $(this).val();
		$("#FORMULARIO_BUSQUEDA").submit();
	});
	
	function fncObtenerDatosContaminanteEstacion(){
		
		var idEstacion = $("#cmbEstacion").rup_combo("getRupValue");
		var idContaminante = $("#cmbContaminante").rup_combo("getRupValue");
		
		//obtengo la lista de contaminantes para dibujar los checks
		$.rup_ajax({
			url: $.rup.CTX_PATH+"contaminantesestacion/" + idEstacion + "/" + idContaminante ,
			dataType: 'json',
			type: "GET",
			async: false,
			contentType: 'application/json',		    
			success: function (resultado, ajaxOptions) {
				
				tituloGrafico = "";
				unidadMedida = "";
				nombreContaminante = "";
				
				if (resultado != null){					
					tituloGrafico = resultado.contaminante.nombreContaminante + " - " + resultado.estacion.nombreEstacion + " (" + resultado.estacion.direccionEstacion + ")";
					unidadMedida = resultado.contaminante.unidadMedida;
					nombreContaminante = resultado.contaminante.nombreContaminante;					
				}
				
				//asigno el titulo al acordeon con el nombre del contaminante seleccionado en el combo
				$("#tituloAcordeon").text(tituloGrafico);
				
				fncObtenerLimitesContaminante();
				
			},
			error: function (xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
				$.unblockUI();
			}
		});
	}
	
	function fncObtenerLimitesContaminante(){
		
		$("#feedbackMensajes").rup_feedback("hide"); //oculto las validaciones.
		
		//obtengo la lista de avisos generales
		$.rup_ajax({
			//url: $.rup.CTX_PATH+"limitesContaminante/" + $("#cmbContaminante").rup_combo("getRupValue"),
			url: $.rup.CTX_PATH+"limitesContaminante",
			data:{
				idContaminante: $("#cmbContaminante").rup_combo("getRupValue"),
				tipoLimite: TIPO_LIMITE_DIARIO
			},
			dataType: 'json',
			type: "GET",
			async: false,
			contentType: 'application/json',		    
			success: function (resultado, ajaxOptions) {
				
				arrLimites = new Array();
				if (resultado != null && resultado.length > 0){
					arrLimites.length = resultado.length - 1;
					
					//cargo la lista de avisos generales
					for (var i=0; i<resultado.length; i++){
						
						arrLimites[i]=
						{
							value : resultado[i].valorLimite,
							color :  resultado[i].colorLimite,
							dashStyle : 'shortDashDot',
							width : 2,
							label : {
								text : resultado[i].descripcion + ": " + resultado[i].valorLimite,
								align: 'center'
							},
							zIndex: 1000
						};
						
					}
				}
				
				$("#FORMULARIO_BUSQUEDA").submit();
				
			},
			error: function (xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
				$.unblockUI();
			}
		});
		
	}
	
	$("#FORMULARIO_BUSQUEDA").rup_form({
		url:$.rup.CTX_PATH+"datohistorico",
		feedback:$("#feedbackMensajes"),
		type: "POST",
		dataType: "json",
		success:function(xhr){
			
			$("#divResultado").show();
			
			if (xhr.length > 0){
				
				//oculto los criterios de busqueda
				$("#divCriteriosBusqueda").accordion({
					  active: false
				});
				
				$("#divMensajeNoHayDatos").hide();
				$("#divPlantilla").show();
				
				$("#divGrafico").css("width",$('#divCriteriosBusqueda').width()*0.94);
			
				//dibujo un grafico y una tabla por cada contaminante
				fncCargarGrafico(xhr);
				
				//defino todos los acordeones que acabo de generar
				$(".acordeonResultado").rup_accordion({
					collapsible: true
				});
				
				//asocio a los campos fecha del grafico el calendario para que se muestre al coger el foco. además establezco el rango de fechas que ha insertado en los criterios de búsqueda
				setTimeout('$(".highcharts-range-selector").datepicker({minDate: "' + $("#txtFecha").rup_date("getDate") + '", maxDate: "' + $("#txtFechaHasta").rup_date("getDate") + '"});',1500);
				
				
			}else{
				$("#divMensajeNoHayDatos").show();
				$("#divPlantilla").hide();
			}
			
			$.unblockUI();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			$.unblockUI();
		},
		validate:{
			rules:{
				"fechaDesde":{date:true},
				"fechaHasta":{date:true}
			},
			invalidHandler: function () {
				$.unblockUI();
			}
		}
	});	
	
	function fncCargarGrafico(datos){
		//$.getJSON('http://www.highcharts.com/samples/data/jsonp.php?filename=aapl-c.json&callback=?', function(datos) {

			$("#divGrafico").highcharts('StockChart', {
				rangeSelector : {
					selected : 1
				},

				title : {
					text : tituloGrafico
				},
				rangeSelector:{
					inputDateFormat: $.rup.lang == "es" ? '%d/%m/%Y' : '%Y/%m/%d',
					inputEditDateFormat: $.rup.lang == "es" ? '%d/%m/%Y' : '%Y/%m/%d',
					inputDateParser: function(value) {		                
						value = value.split("/");
						if ($.rup.lang == "es"){
			                return new Date(
			                    parseInt(value[2],10), 
			                    parseInt(value[1],10)-1, 
			                    parseInt(value[0],10),
			                    12,00,00);
						}else{
							return new Date(
				                    parseInt(value[0],10), 
				                    parseInt(value[1],10)-1, 
				                    parseInt(value[2],10),
				                    12,00,00);
						}
		            },
					inputEnabled: true,
					buttons: botonesZoomGrafico //definidos en archivo configuracionGrafico.js
				},
				series : [{
					name : nombreContaminante,
					data : datos,
					type : tipoGrafico,
					threshold : null,
					tooltip : {
						valueDecimals : 2
						//,xDateFormat: ["%A", "%Y", "%B"]
					},
					fillColor : {
						linearGradient : {
							x1: 0, 
							y1: 0, 
							x2: 0, 
							y2: 1
						},
						stops : [[0, Highcharts.getOptions().colors[0]], [1, 'rgba(0,0,0,0)']]
					},
					dataGrouping:{
						dateTimeLabelFormats: {
						   millisecond: ['%d %b %Y', '%d %b %Y', ''],
						   second: ['%d %b %Y', '%d %b %Y', ''],
						   minute: ['%d %b %Y', '%d %b %Y', ''],
						   hour: ['%d %b %Y', '%d %b %Y', ''],
						   day: ['%d %b %Y', '%d %b %Y', ''],
						   week: ['%d %b %Y', '%d %b %Y', ''],
						   month: ['%d %b %Y', '%d %b %Y', ''],
						   year: ['%d %b %Y', '%d %b %Y', '']
						}
					}
				}],
				yAxis : {
					title : {
						text : unidadMedida
					},
					plotLines : arrLimites					
				},
				xAxis: {
			        type: 'datetime',
			        labels: {
			            format: '{value:%d %b %Y}'
			            //rotation: 45,
			          //  align: 'left'
			        }
			    }
			});
		//});
	}
	
	// Para el calendario que sale en el rango de fechas del grafico
	/* Inicialización en español para la extensión 'UI date picker' para jQuery. */
	jQuery(function($){
		$.datepicker.regional['es'] = {
			closeText: $.rup.i18n.base.rup_date.closeText,
			prevText: $.rup.i18n.base.rup_date.prevText,
			nextText: $.rup.i18n.base.rup_date.nextText,
			currentText: $.rup.i18n.base.rup_date.currentText,
			monthNames: $.rup.i18n.base.rup_date.monthNames,
			monthNamesShort: $.rup.i18n.base.rup_date.monthNamesShort,
			dayNames: $.rup.i18n.base.rup_date.dayNames,
			dayNamesShort: $.rup.i18n.base.rup_date.dayNamesShort,
			dayNamesMin: $.rup.i18n.base.rup_date.dayNamesMin,
			weekHeader: 'Sm',
			dateFormat: $.rup.i18n.base.rup_date.dateFormat,
			firstDay: 1,
			isRTL: false,
			showMonthAfterYear: false,
			yearSuffix: ''};
		$.datepicker.setDefaults($.datepicker.regional['es']);
	});
	
	
});

